----------------------------------------------------------------------------
-- Copyright: ViperGTS96--------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

rdcSnowMelter = {};

function rdcSnowMelter:update(dt)
	if g_currentMission.missionInfo.isSnowEnabled and g_currentMission.justSnow == nil then
		if realDirtColor.realTimeSnowMelting then
			local temperature = g_currentMission.environment.weather:getCurrentTemperature();
			if temperature > 5 then
				for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
					--if vehicle:getLastSpeed() < realDirtColor.minVehicleSpeed then
						if vehicle.spec_realDirtColor ~= nil then

							local spec = vehicle.spec_realDirtColor;
							if spec.bodypart ~= nil and #spec.bodypart > 0 then
								
								if spec.currentDirtColor == 2 then
									local curColor = {};
									curColor.r, curColor.g, curColor.b, curColor.a = getShaderParameter(spec.bodypart[1], "dirtColor");
									curColor.r, curColor.g, curColor.b = vehicle:colorChangeLerp(curColor, realDirtColor.colors.dryDirt, realDirtColor.speeds.wheels*realDirtColor.speeds.boost);
									for _, part in pairs(spec.bodypart) do
										setShaderParameter(part, "dirtColor", curColor.r, curColor.g, curColor.b, curColor.a, false);
									end;
									if vehicle:thresholdCompareColor(curColor, realDirtColor.colors.dryDirt, 0.0001) then
										spec.targetRDColor.r, spec.targetRDColor.g, spec.targetRDColor.b = realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b;
										if spec.tireTrackColor ~= nil then
											spec.tireTrackColor.r, spec.tireTrackColor.g, spec.tireTrackColor.b = realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b;
										end;
										spec.previousDirtColor = 2;
										spec.currentDirtColor = 0.1;
										spec.newDirtColor = 0;
									end;
								end;
								
								if not spec.useSimpleMode then
									if vehicle.spec_wheels ~= nil then
										for _,wheel in pairs(vehicle.spec_wheels.wheels) do
											if wheel.rDC ~= nil and wheel.bodypart ~= nil and #wheel.bodypart > 0 then
												if wheel.currentDirtColor == 2 then
													local curColor = {};
													curColor.r, curColor.g, curColor.b, curColor.a = getShaderParameter(wheel.bodypart[1], "dirtColor");
													curColor.r, curColor.g, curColor.b = vehicle:colorChangeLerp(curColor, realDirtColor.colors.dryDirt, realDirtColor.speeds.wheels*realDirtColor.speeds.boost);
													for _, part in pairs(wheel.bodypart) do
														setShaderParameter(part, "dirtColor", curColor.r, curColor.g, curColor.b, curColor.a, false);
													end;
													if vehicle:thresholdCompareColor(curColor, realDirtColor.colors.dryDirt, 0.0001) then
														wheel.targetRDColor.r, wheel.targetRDColor.g, wheel.targetRDColor.b = realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b;
														if wheel.tireTrackColor ~= nil then
															wheel.tireTrackColor.r, wheel.tireTrackColor.g, wheel.tireTrackColor.b = realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b;
														end;
														wheel.previousDirtColor = 2;
														wheel.currentDirtColor = 0.1;
														wheel.newDirtColor = 0;
													end;
												end;
											end;
										end;
									end;
								end;

							end;

						end;
					--end;
				end;
			end;
		end;
	end;

end;

addModEventListener(rdcSnowMelter);