function cloneList(list)
    local clone = {}
    for i = 1, #list do
        clone[i] = list[i]
    end
    return clone
end

function removeDuplicates(list)
    local seen = {}
    local uniqueList = {}

    for _, value in ipairs(list) do
        if not seen[value] then
            seen[value] = true
            table.insert(uniqueList, value)
        end
    end

    return uniqueList
end

function TableContains(array, valueToFind)
    for i = 1, #array do
        if array[i] == valueToFind then
            return true
        end
    end
    return false
end

function IconFileNameToFillTypeIndex(IconFileName)
    for _, fillType in ipairs(g_fillTypeManager:getFillTypes()) do
        if fillType.hudOverlayFilename == IconFileName then
            return fillType.index
        end
    end

    return nil;
end


function ConstructionScreen:GetFilteredFillTypeInputs(OutputFilltypeIndex)

    local FillTypes = {}

    for i = 1, #ConstructionScreen.ExtendedItemList do
        for n = 1, #ConstructionScreen.ExtendedItemList[i].InputTypes do    
            local FillType = ConstructionScreen.ExtendedItemList[i].InputTypes[n];
            if OutputFilltypeIndex == nil or TableContains(ConstructionScreen.ExtendedItemList[i].OutputTypes,OutputFilltypeIndex) then  
                 table.insert(FillTypes, FillType);
            end
        end
    end

    return removeDuplicates(FillTypes);
end

function ConstructionScreen:GetFilteredFillTypeOutputs(InputFilltypeIndex)

    local FillTypes = {}

    for i = 1, #ConstructionScreen.ExtendedItemList do
        for n = 1, #ConstructionScreen.ExtendedItemList[i].OutputTypes do    
            local FillType = ConstructionScreen.ExtendedItemList[i].OutputTypes[n];

            if InputFilltypeIndex == nil or TableContains(ConstructionScreen.ExtendedItemList[i].InputTypes,InputFilltypeIndex) then  
                table.insert(FillTypes, FillType);
            end
        end
    end

    return removeDuplicates(FillTypes);
end

function removeNil(t)
    local result = {}
    local j = 1
    for i = 1, #t do
        if t[i] ~= nil then
            result[j] = t[i]
            j = j + 1
        end
    end
    return result
end

function ConstructionScreen:ForceRebuild()
    local currentCategory = ConstructionScreen.Ins.currentCategory;
    local currentTab = ConstructionScreen.Ins.currentTab;
    
    ConstructionScreen.Ins:rebuildData()
	--ConstructionScreen.Ins:resetMenuState()
	ConstructionScreen.Ins:updateMenuState()

    ConstructionScreen.Ins.currentCategory = currentCategory;
    ConstructionScreen.Ins.currentTab = currentTab;

    ConstructionScreen.Ins:updateMenuState()
    ConstructionScreen.Ins:setBrush(ConstructionScreen.Ins.selectorBrush, true)
end


function ConstructionScreen:registerMenuActionEventsExt()
    _, eventId = g_inputBinding:registerActionEvent(InputAction.SortInput, "SortInput", self.InputFilterAction, false, true, false, true);
    table.insert(self.menuEvents, eventId);
    self.SortInputEventId = eventId;

    _, eventId = g_inputBinding:registerActionEvent(InputAction.SortOutput, "SortOutput", self.OutputFilterAction, false, true, false, true);
    table.insert(self.menuEvents, eventId);
    self.SortOutputEventId = eventId;


    g_inputBinding:setActionEventTextVisibility(self.SortInputEventId,true);
    g_inputBinding:setActionEventTextVisibility(self.SortOutputEventId,true);


    if self.InputFillTypeFilter ~= nil then 
        g_inputBinding:setActionEventText(self.SortInputEventId,  g_i18n:getText("text_ClearInputFilter"));
    end

    if self.OutputFillTypeFilter ~= nil then 
        g_inputBinding:setActionEventText(self.SortOutputEventId,  g_i18n:getText("text_ClearOutputFilter"));
    end

end

function ConstructionScreen:InputFilterAction(_, inputValue, _, isAnalog, isMouse)

    if not SortIo.ShouldShow then return end
    
    if ConstructionScreen.InputFillTypeFilter ~= nil then 
        ConstructionScreen.InputFillTypeFilter = nil;
        ConstructionScreen:ForceRebuild();
        return;
    end

    local validFillLevels = {}
    local AvaivleFilltypes = ConstructionScreen:GetFilteredFillTypeInputs(ConstructionScreen.OutputFillTypeFilter);
    for i = 1, #AvaivleFilltypes do
        validFillLevels[AvaivleFilltypes[i]] = 1;
    end

    SortIo:showSiloDialog({
        title = "Select",
        text = "input",
        fillLevels = validFillLevels,
        callback = ConstructionScreen.InputFilterCallback,
        target = ConstructionScreen,
        hasInfiniteCapacity = true
    })
end

function ConstructionScreen:OutputFilterAction(_, inputValue, _, isAnalog, isMouse)

    if not SortIo.ShouldShow then return end

    if ConstructionScreen.OutputFillTypeFilter ~= nil then 
        ConstructionScreen.OutputFillTypeFilter = nil;
        ConstructionScreen:ForceRebuild();
        return;
    end

    local validFillLevels = {}
    local AvaivleFilltypes = ConstructionScreen:GetFilteredFillTypeOutputs(ConstructionScreen.InputFillTypeFilter);
    for i = 1, #AvaivleFilltypes do
        validFillLevels[AvaivleFilltypes[i]] = 1;
    end

    SortIo:showSiloDialog({
        title = "Select",
        text = "Output",
        fillLevels = validFillLevels,
        callback = ConstructionScreen.OutputFilterCallback,
        target = ConstructionScreen,
        hasInfiniteCapacity = true
    })
end


function ConstructionScreen:InputFilterCallback(SelectedFillType)
    if SelectedFillType ~= nil and SelectedFillType ~= FillType.UNKNOWN then
        ConstructionScreen.InputFillTypeFilter = SelectedFillType;
        ConstructionScreen:ForceRebuild();
	end 
end

function ConstructionScreen:OutputFilterCallback(SelectedFillType)
    if SelectedFillType ~= nil and SelectedFillType ~= FillType.UNKNOWN then
        ConstructionScreen.OutputFillTypeFilter = SelectedFillType;
        ConstructionScreen:ForceRebuild();
	end 
end

function StoreManager:getItemsEx()

    if StoreManager.FilterRequest == nil then
        return self.items;
    else

        local Returning = cloneList(self.items);
        local ExcludeList = {};

        if ConstructionScreen.InputFillTypeFilter ~= nil then
            for i = 1, #ConstructionScreen.ExtendedItemList do
                if not TableContains(ConstructionScreen.ExtendedItemList[i].InputTypes, ConstructionScreen.InputFillTypeFilter) or #ConstructionScreen.ExtendedItemList[i].InputTypes == 0 then
                    if ConstructionScreen.ExtendedItemList[i].IsProdPoint or #ConstructionScreen.ExtendedItemList[i].InputTypes == 0 then
                        table.insert(ExcludeList,ConstructionScreen.ExtendedItemList[i].xmlFilename);
                    end
                end
            end
        end

        if ConstructionScreen.OutputFillTypeFilter ~= nil then
            for i = 1, #ConstructionScreen.ExtendedItemList do
                if not TableContains(ConstructionScreen.ExtendedItemList[i].OutputTypes, ConstructionScreen.OutputFillTypeFilter) or #ConstructionScreen.ExtendedItemList[i].OutputTypes == 0 then
                    if ConstructionScreen.ExtendedItemList[i].IsProdPoint then 
                        table.insert(ExcludeList,ConstructionScreen.ExtendedItemList[i].xmlFilename);
                    end
                end
            end
        end



        if #ExcludeList > 0 then
        for i = #Returning, 1, -1 do
            if TableContains(ExcludeList,Returning[i].xmlFilename) then
                table.remove(Returning, i)
            end
        end
    
    end

        return Returning;
    end
end

function ConstructionScreen:BeforeRebuildData()
    StoreManager.FilterRequest = true;
end

function ConstructionScreen:AfterRebuildData()
    StoreManager.FilterRequest = nil;
    ConstructionScreen.Ins = self;
end

SortIo = {};
function SortIo:update(...)
    if ConstructionScreen.Ins == nil then return end
    if g_gui.currentGuiName ~= "ConstructionScreen" then return end

    SortIo.ShouldShow = ConstructionScreen.Ins.currentCategory == 2 and ConstructionScreen.Ins.currentTab == 1 and ConstructionScreen.Ins.brush.isSelector;

    g_inputBinding:setActionEventTextVisibility(ConstructionScreen.Ins.SortInputEventId,SortIo.ShouldShow);
    g_inputBinding:setActionEventTextVisibility(ConstructionScreen.Ins.SortOutputEventId,SortIo.ShouldShow);

    if SortIo.ShouldShow then
    local TipText = "";
    
    if ConstructionScreen.Ins.InputFillTypeFilter ~= nil then 
        g_inputBinding:setActionEventText(ConstructionScreen.Ins.SortInputEventId,  g_i18n:getText("text_ClearInputFilter"));
        TipText = g_i18n:getText("text_InputFilter")..": "..g_fillTypeManager:getFillTypeByIndex(ConstructionScreen.Ins.InputFillTypeFilter).title
    else
        g_inputBinding:setActionEventText(ConstructionScreen.Ins.SortInputEventId,  g_i18n:getText("input_SortInput"));
    end

    if ConstructionScreen.Ins.OutputFillTypeFilter ~= nil then 
        g_inputBinding:setActionEventText(ConstructionScreen.Ins.SortOutputEventId,  g_i18n:getText("text_ClearOutputFilter"));
        if #TipText > 0 then TipText = TipText..", " end
        TipText = TipText..g_i18n:getText("text_OutputFilter")..": "..g_fillTypeManager:getFillTypeByIndex(ConstructionScreen.Ins.OutputFillTypeFilter).title

    else
        g_inputBinding:setActionEventText(ConstructionScreen.Ins.SortOutputEventId,  g_i18n:getText("input_SortOutput"));
    end

    if #TipText > 0 then
        g_currentMission:addExtraPrintText(TipText);
    end
end
end

function SortIo:loadMap(savegame)
end

addModEventListener(SortIo);

ConstructionScreen.registerMenuActionEvents = Utils.appendedFunction(ConstructionScreen.registerMenuActionEvents, ConstructionScreen.registerMenuActionEventsExt);
StoreManager.getItems = Utils.overwrittenFunction(StoreManager.getItems, StoreManager.getItemsEx);
ConstructionScreen.rebuildData = Utils.prependedFunction(ConstructionScreen.rebuildData, ConstructionScreen.BeforeRebuildData);
ConstructionScreen.rebuildData = Utils.appendedFunction(ConstructionScreen.rebuildData, ConstructionScreen.AfterRebuildData);

function SortIo:showSiloDialog(args)
	local dialog = g_gui:showDialog("SiloDialog")

	if dialog ~= nil and args ~= nil then
		dialog.target:setTitle(args.title)
		dialog.target:setText(args.text)
		dialog.target:setFillLevels(args.fillLevels, args.hasInfiniteCapacity)
		dialog.target:setCallback(args.callback, args.target, args.args)
	end
end

function ConstructionScreen:BuildExtendedItemList()
    local ExtendedItemList = {}

    for _, storeItem in ipairs(g_storeManager:getItems()) do
		if storeItem.brush ~= nil then
			local brushClass = g_constructionBrushTypeManager:getClassObjectByTypeName(storeItem.brush.type)
			if brushClass ~= nil then
                if storeItem.brush.tab.title == "Factories" then
                    local displayItem = SortIo.ShopController:makeDisplayItem(storeItem);

                    local InputTypes = {}
                    local OutputTypes = {}

                    for i = 1, #displayItem.prodPointInputFillTypeIconFilenames do
                        table.insert(InputTypes, IconFileNameToFillTypeIndex(displayItem.prodPointInputFillTypeIconFilenames[i]))
                    end

                    for i = 1, #displayItem.prodPointOutputFillTypeIconFilenames do
                        table.insert(OutputTypes, IconFileNameToFillTypeIndex(displayItem.prodPointOutputFillTypeIconFilenames[i]))
                    end

                    InputTypes = removeNil(InputTypes);
                    OutputTypes = removeNil(OutputTypes);

                    local ExtenedItem = {xmlFilename = storeItem.xmlFilename, InputTypes = InputTypes, OutputTypes = OutputTypes, IsProdPoint = true, IsSellPoint = false};
                    table.insert(ExtendedItemList,ExtenedItem);
                end
			end
		end
	end

    ExtendedItemList = removeNil(ExtendedItemList);
    return ExtendedItemList;
end

function ShopController:LoadExtended()
    SortIo.ShopController = self;
    ConstructionScreen.ExtendedItemList = ConstructionScreen:BuildExtendedItemList();
end


ShopController.load = Utils.appendedFunction(ShopController.load, ShopController.LoadExtended);